function [path,dist,X]  = find_tracks(A,K)

N = (size(A,1)-2)/2;

path = [];
dist = [];

for k=1:K
    [d,p] = graphshortestpath(A,2*N+1,2*N+2,'Method','Bellman-Ford');
    for i=1:length(p)-1
        A(p(i+1),p(i)) = -A(p(i),p(i+1)); % negative edge in opposite direction
        A(p(i),p(i+1)) = 0; % removing current edge 
    end
    
    if d < 0
        break
    end
    
    dist(k) = d;
    path{k} = p;
    
    fprintf('k %i of %i length(path) %i dist %f\n',k,K,length(p),d)
end
