% returns Adjacency matrix A for a given set of nodes in format [x y size
% time]
function [A]= build_adjacency_matrix(X,start,stop,skips,w_start,w_stop,max_dist)
   
    N = size(X,1);
    A = sparse(N*2,N*2);
    % observation edges
    A = A + spdiags( repmat([0;eps],N,1) ,1, N*2, N*2);
    % transition edges
    T = unique(X(:,4));
    
     if numel(start) == 3 & numel(stop) ==3 
         d_start = w_start* pdist2(X(:,[1 2 4]),start);
         d_stop =  w_stop* pdist2(X(:,[1 2 4]),stop);
     else
        d_start = w_start* pdist2(X(:,1:2),start);
        d_stop =  w_stop* pdist2(X(:,1:2),stop);
     end
     
     % all starting positions are equally like, therefore only distance to
     % start and stop of a current node matters
     if all(isnan(start(1:2))) & all(isnan(stop(1:2))) & ...
             (length(start) == 3) & (length(stop) == 3)
         d_start = w_start * (X(:,4)-start(3)).^2;
         d_stop  = w_start * (X(:,4)-stop(3)).^2;
     end

    for i=1:length(T)-skips
        ind_t1 = find(X(:,4) == T(i));
        for j=1:skips

            ind_tn = find(X(:,4) == T(i+j));
            d = pdist2(X(ind_t1,1:2),X(ind_tn,1:2));
            d(d(:) > max_dist) = 0;

            A(2*ind_t1,2*(ind_tn)-1) = d;
        end
    end

    % enter/exit edges
    A(2*N+1,2*N+1) = 0; % source
    A(2*N+1,:) = [reshape([d_start'; zeros(1,N)],1,[]) 0]; % [repmat([1 0],1,N), 0]; % source

    A(2*N+2,2*N+2) = 0; % target/sink
    A(:,2*N+2) = [reshape([zeros(1,N); d_stop'],1,[]) 0 0];% [repmat([0;1],N,1); 0;0]; % target/sink
end