cd ~/animal_behavior/code/ants_tracking_scaffolding/
% clear all;
close all
clc;

%% loading stuff
folder = '../../data/ants_tracking_scaffolding/90/';
max_dist = 50; % maximum distance threshold between frames
skips = 2; % maximum number of skips
w_start = 6;
w_stop = 6;

files = dir([folder '*.mov']);

%{


left_right = [      false,...% '20_2-5_1.mov'
                    false,...% '20_2-5_2.mov'
                    false,...% '20_2-5_3.mov'
                    false,...% '20_2-5_4.mov'
                    false,...% '20_2-5_5.mov'
                    false,...% '20_2-6_1.mov'
                    false,...% '20_2-6_2.mov'
                    false,...% '20_2-6_3.mov'
                    false,...% '20_2-6_4.mov'
                    false] % '20_2-6_5.mov'


left_right = [      false,...% '30_2-5_1.mov'
                    false,...% '30_2-5_2.mov'
                    false,...% '30_2-5_3.mov'
                    false,...% '30_2-5_4.mov'
                    false,...% '30_2-5_5.mov'
                    false,...% '30_2-5_short.mov'
                    false,...% '30_2-6_1.mov'
                    false,...% '30_2-6_2.mov'
                    false,...% '30_2-6_3.mov'
                    false,...% '30_2-6_4.mov'
                    false,...% '30_2-6_5.mov'    
                    false] % '30_2-6_6.mov'

left_right = [  false,...% '40_2-5_1.mov'
                false,...% '40_2-5_2.mov'
                false,...% '40_2-5_3.mov'
                false,...% '40_2-5_4.mov'
                false,...% '40_2-5_5.mov'
                false,...% '40_2-6_1.mov'
                false,...% '40_2-6_2.mov'
                false,...% '40_2-6_3.mov'
                false,...% '40_2-6_4.mov'
                false] % '40_2-6_5.mov'

left_right = [ true,... % 50_1-23_1.mov
               true,... % 50_1-31_1.mov
               true,... % 50_1-31_2.mov
               true,... % 50_1-31_3.mov
               false,... % 50_2-1_1.mov
               false,... % 50_2-1_2.mov
               false,... % 50_2-2_1.mov
               false,... % 50_2-2_2.mov
               false,... % 50_2-5_1.mov
               false,... % 50_2-5_2.mov
               false]% 50_2-6_1.mov

left_right = [true,...  % 60_1-23_1.mov
              true,...  % 60_1-23_2.mov
              true,...  % 60_1-31_1.mov
              true,...  % 60_1-31_2.mov
              false,...  % 60_2-1_1.mov
              false,...  % 60_2-1_2.mov
              true,...  % 60_2-2_1.mov
              false,...  % 60_2-2_2.mov
              false,...  % 60_2-5_1.mov
              false,...  % 60_2-5_2.mov
              false,...  % 60_2-5_3.mov
              false]% 60_2-6_1.mov
left_right = [true,...  % 70_1-23_1.mov
              true,...  % 70_1-23_2.mov
              true,...  % 70_1-31_1.mov
              true,...  % 70_1-31_2.mov
              false,...  % 70_2-1_1.mov
              false,...  % 70_2-1_2.mov
              false,...  % 70_2-2_1.mov
              false,...  % 70_2-2_2.mov
              false,...  % 70_2-2_3_notraffi
              false,...  % 70_2-5_1.mov
              false,...  % 70_2-5_2.mov
              false]% 70_2-5_3.mov


left_right = [true,...  % 80_1-23_1.mov
              true,...  % 80_1-31_1.mov
              true,...  % 80_1-31_2a.mov 
              true,...  % 80_1-31_2b.mov
              true,...  % 80_1-31_3.mov
              false,...  % 80_2-1_1.mov
              false,...  % 80_2-1_2.mov
              false,...  % 80_2-2_1.mov
              false,...  % 80_2-2_2.mov
              false,...  % 80_2-5_1.mov
              false,...  % 80_2-5_2.mov
              false]  % 80_2-6_1.mov

left_right = [  true,... 90_1-23_1.mov
                true,... 90_1-31_1.mov
                true,... 90_1-31_2.mov
                true,... 90_1-31_3.mov
                false,... 90_2-1_1.mov
                false,... 90_2-1_2.mov
                false,... 90_2-2_1.mov
                false,... 90_2-2_2.mov
                false,... 90_2-5_1.mov
                false,... 90_2-5_2.mov
                false]; % 90_2-5_3.mov
%}

for i=1:length(files)
    fname = files(i).name(1:end-4);
    fprintf('Processing %s\n',fname)
    detections = load([folder 'out/' fname '/' fname '.mat']);
    mask = imread([folder fname '.png']);
    
    %
    fprintf('regionprops_2_xyat'); tic
    X = regionprops_2_xyat(detections.objects);
    fprintf('regionprops_2_xyat done %f\n', toc)
    
    if left_right(i)
        start = [min(X(:,1)) mean(X(:,2))];
        stop =  [max(X(:,1)) mean(X(:,2))];
    else
        start = [max(X(:,1)) mean(X(:,2))];
        stop =  [min(X(:,1)) mean(X(:,2))];
    end
    
    K = uint16(min(1000,size(X,1) / 20));
    %
    fprintf('build_adjacency_matrix'); tic
    [A] = build_adjacency_matrix(X,start,stop,skips,w_start,w_stop,max_dist);
    fprintf('build_adjacency_matrix done (%i) %f\n',size(A,1), toc)
    %
    [path, dist] = find_tracks(A,K);
    %
    [tracks] = paths_2_tracks(X,path);
    fprintf('Processed %s\n',fname)
    save([folder 'out/' fname '/tracks_' fname '.mat'],'A','path','dist','tracks','X');
end