close all
clear all
clc

folder = '/home/sulcanto/animal_behavior/data/ants_tracking_scaffolding/80/out/'
folders = dir([folder '*'])

for i=1:length(folders)
    path = [folder folders(i).name '/tracks_' folders(i).name '.mat'];
    if ~exist(path)
        continue
    end
    load(path)
    
    f = figure;
    hold on; 
    for j=1:length(tracks)
        t = tracks{j};
        plot3(t(:,1),t(:,2),t(:,4) - min(t(:,4)))
    end
    xlabel('x');ylabel('y'); zlabel('z')
    view(20,20)
    print(f,['~/tmp/' folders(i).name '.pdf'],'-dpdf')
%     close all
end
