clear all
close all
clc

addpath('../libs/SVD/')
addpath('../libs/FPCP/')
addpath('../functions/')
%%
subsample = 1;
lambda = 0.1;
min_area = 200;
max_area = 20000;
chunk_size = 50;

folder = '/home/sulcanto/Documents/animal_behavior/data/ants_tracking_scaffolding/80/';
files = dir([folder '*.mov']);

for file = 1:length(files)
    mkdir([folder '/out/' files(file).name(1:end-4)])
    
    in = VideoReader([folder files(file).name]);
    mask = imread([folder files(file).name(1:end-3) 'png']);
    mask = (mask(:,:,1) == 255) & (mask(:,:,2) == 0) & (mask(:,:,3) == 0);
    out = VideoWriter([folder '/out/' files(file).name(1:end-4) '/' files(file).name(1:end-3) 'avi']);
    open(out);

    height = in.Height / subsample;
    width = in.Width / subsample;
    num_frames = uint16(in.Duration * in.FrameRate);

    mask = imresize(mask,[height,width]);
    objects = [];
    while hasFrame(in)
        tic
        [I,X] = chop_video(in,height,width,chunk_size);
        [o] = object_detection_rpca(X,mask,lambda,min_area,max_area);
        objects = cat(2,objects,o);
        
        for i=1:length(o)
            img = plot_bboxes_to_image(im2double(I(:,:,:,i)),o(i).bbox);
            writeVideo(out,img);
        end
        time_spent = toc;

        
        current_frame = uint16(in.FrameRate * in.CurrentTime);
        time_spent = toc;
        fprintf('] (processed %i of %i, est.time %f \n',current_frame,num_frames, time_spent * (( num_frames - current_frame ) / chunk_size));
        clear I X;
    end
    close(out)
    save([folder '/out/' files(file).name(1:end-4) '/' files(file).name(1:end-3) 'mat'],'objects')
end