
function [] = rpca_object_detection(folder, fname, subsample, lambda, min_area,max_area,chunk_size)

in = VideoReader([folder fname]);
mkdir([folder 'out/' fname(1:end-4)])
out = VideoWriter([folder 'out/' fname(1:end-4) '/' fname(1:end-3) 'avi']);
open(out);
mask = imread([folder fname(1:end-3) 'png']);
mask = (mask(:,:,1) == 255) & (mask(:,:,2) == 0) & (mask(:,:,3) == 0);
W = in.Width / subsample;
H = in.Height / subsample;
NF = uint16(in.Duration * in.FrameRate);

%%
I = zeros(H,W,3,chunk_size,'uint8');
X = zeros(H*W,chunk_size,'double');

bn_y = @(y) min(H,max(1,y));
bn_x = @(x) min(W,max(1,x));

objects = [];

while hasFrame(in)
    tic
    
    fprintf('Reading (%i,%s) frames [',chunk_size,fname)
    f = 1;
    while f <= chunk_size & hasFrame(in)
        img = imresize(readFrame(in),[H,W]);
        I(:,:,:,f) = img;
        img = im2double(rgb2gray(img));
        X(:,f) = img(:);
        fprintf('.')
        f = f+1;
    end
    fprintf('] done\n')
    I = I(:,:,:,1:f-1);
    X = X(:,1:f-1);
    chunk_size = f-1;
    
    % PCP
    
    CF = uint16(in.FrameRate * in.CurrentTime);
    time_spent = toc;
    fprintf('] (processed %i of %i, est.time %f \n',CF,NF, time_spent * (( NF - CF ) / chunk_size));
    clear S;
end

close(out)
save([folder 'out/' fname(1:end-4) '/' fname(1:end-3) 'avi'],'objects')
end