function optical_flow_mag_detection(folder, files)
for i_file = 1:length(files)
    in = VideoReader([folder files(i_file).name]);
    out = VideoWriter([folder '/res/' files(i_file).name(1:end-3) 'avi']);
    open ( out );
    
    mask = imread([folder files(i_file).name(1:end-3) 'png']);
    mask = (mask(:,:,1) == 255) & (mask(:,:,2) == 0) & (mask(:,:,3) == 0);
    mask = logical(mask);
    
    H = in.Height;
    W = in.Width;
    nf = uint16(in.FrameRate * in.Duration);
    
    hblob = vision.BlobAnalysis(...
        'CentroidOutputPort', true, 'AreaOutputPort', true, ...
        'BoundingBoxOutputPort', true,'MinimumBlobArea',300, 'MaximumBlobArea',25000);
    
    hfg = vision.ForegroundDetector(...
        'NumTrainingFrames', 50, ...
        'InitialVariance', 0.2 * 0.2);
    frame = 1;
    data = cell(nf,1);
    
    while hasFrame(in)
        img = im2single(readFrame(in));
        fg_mask = step(hfg, rgb2gray(img));
        fg_mask = logical(fg_mask .* mask);
        [area, centroid, bbox] = step(hblob,fg_mask);
        data{frame}.current_frame = frame;
        data{frame}.area = area;
        data{frame}.centroid = centroid;
        data{frame}.bbox = bbox;
        
        frame = frame +1;
        
        for k = 1:size(bbox,1)
            x = bbox(k,1);
            y = bbox(k,2);
            w = bbox(k,3);
            h = bbox(k,4);
            bn_y = @(y) min(H,max(1,y));
            bn_x = @(x) min(W,max(1,x));
            
            
            img(bn_y(y):bn_y(y+h),bn_x(x),1) = 1;
            img(bn_y(y):bn_y(y+h),bn_x(x),2:3) = 0;
            
            img(bn_y(y):bn_y(y+h),bn_x(x+w),1) = 1;
            img(bn_y(y):bn_y(y+h),bn_x(x+w),2:3) = 0;
            
            img(bn_y(y),bn_x(x):bn_x(x+w),1) = 1;
            img(bn_y(y),bn_x(x):bn_x(x+w),2:3) = 0;
            
            img(bn_y(y+h),bn_x(x):bn_x(x+w),1) = 1;
            img(bn_y(y+h),bn_x(x):bn_x(x+w),2:3) = 0;
        end
        writeVideo(out,img);
        
        fprintf('%s,%i,%i\n',files(i_file).name,frame,nf)
    end
    
    close(out);
    save([folder '/res/' files(i_file).name(1:end-3) 'mat'],'data','-v7.3')

    
end
    
    %{
    mag_threshold = 0.01;


    for i_file = 1:length(files)

        in = VideoReader([folder files(i_file).name]);
        out = VideoWriter([folder '/res/' files(i_file).name(1:end-3) 'avi']);
        open ( out );
        mask = imread([folder files(i_file).name(1:end-3) 'png']);
        mask = (mask(:,:,1) == 255) & (mask(:,:,2) == 0) & (mask(:,:,3) == 0);
        mask = logical(mask);

        W = in.Width;
        H = in.Height;

        nf = uint16(in.Duration * in.FrameRate);
        hblob = vision.BlobAnalysis(...
            'CentroidOutputPort', true, 'AreaOutputPort', true, ...
            'BoundingBoxOutputPort', true,'MinimumBlobArea',300, 'MaximumBlobArea',25000);
        hof = opticalFlowHS('Smoothness',5,'MaxIteration',50);
        bboxes = cell(nf,1);
        centroids = cell(nf,1);
        areas = cell(nf,1);
        %
        frame = 1;
        while hasFrame(in)
            img = (im2single(readFrame(in)));

            flow = estimateFlow(hof,rgb2gray(img));
            fg = mask .* (flow.Magnitude > mag_threshold);
            fg = imopen(fg, strel('rectangle', [3,3]));
            fg = imclose(fg, strel('rectangle', [10, 10]));
            fg = imfill(fg, 'holes');
            fg = logical(fg);
            
            imagesc(fg); pause
            
            
            [area, centroid, bbox] = step(hblob,fg);

            for k = 1:size(bbox,1)
                x = bbox(k,1);
                y = bbox(k,2);
                w = bbox(k,3);
                h = bbox(k,4);


                bn_y = @(y) min(H,max(1,y));
                bn_x = @(x) min(W,max(1,x));


                img(bn_y(y):bn_y(y+h),bn_x(x),1) = 1;
                img(bn_y(y):bn_y(y+h),bn_x(x),2:3) = 0;

                img(bn_y(y):bn_y(y+h),bn_x(x+w),1) = 1;
                img(bn_y(y):bn_y(y+h),bn_x(x+w),2:3) = 0;

                img(bn_y(y),bn_x(x):bn_x(x+w),1) = 1;
                img(bn_y(y),bn_x(x):bn_x(x+w),2:3) = 0;

                img(bn_y(y+h),bn_x(x):bn_x(x+w),1) = 1;
                img(bn_y(y+h),bn_x(x):bn_x(x+w),2:3) = 0;
            end
            writeVideo(out,img);
            bboxes{frame} = bbox;
            centroids{frame} = centroid;
            areas{frame} = area;
            frame = frame + 1;
            imagesc(img); pause;
            fprintf('%s %i %i\n',files(i_file).name,frame, nf)
            
        end
        close(out);
        save([folder '/res/' files(i_file).name(1:end-3) 'mat'],'bboxes','centroids','-v7.3')
    end
end
    %}