
folder = '/home/sulcanto/animal_behavior/data/ants_tracking_scaffolding/Antonin_Ants_Scaffolding/Videos/20/';
files = dir([folder '*.mov']);
min_area = 500;
max_area = 2000;

i_file = 1;
subsample = 1;
min_area = min_area / subsample;
max_area = max_area / subsample;


t_frames = 300;
lambda_dict = 0.15;
lambda_code = 0.5;
K = 64;
window_type = 'sliding';

for i_file = 1:length(files)

    in = VideoReader([folder files(i_file).name]);
    NF = uint16(in.Duration * in.FrameRate);
    H = in.Height / subsample;
    W = in.Width / subsample;
   
    % mask
    mask = imread([folder files(i_file).name(1:end-3) 'png']);
    mask = (mask(:,:,1) == 255) & mask(:,:,2) == 0 & mask(:,:,3) == 0;
    mask = imresize(mask,[H,W]);
    

    % fg-bg detector    
    detector = vision.ForegroundDetector(...
        'NumTrainingFrames', 50, ...
        'InitialVariance', 0.2*0.2);

    instances = cell(t_frames,1);
    for f=1:t_frames
        img = imresize(im2single(readFrame(in)),[H,W]);
        img_m = step(detector,img);
        img_m = img_m .* mask;
                
        img_m = imopen(img_m, strel('rectangle', [3,3]));
        img_m = imclose(img_m, strel('rectangle', [10, 10]));
        img_m = imfill(img_m, 'holes');
        
        props = regionprops(logical(img_m));
        props = props ( [props.Area] >= min_area & [props.Area] <= max_area);
        
        instances{f} = cell(length(props),1);
        for i=1:length(props)
            b = props(i).BoundingBox;
            
            img_ = img(b(2):b(2) + b(4), b(1):b(1) + b(3),:);
            instances{f}{i} = img_;
        end
        
        fprintf('%i %i (%i instances) \n',f,t_frames, length(props))
    end   
    
    Wo = [];
    Ho = [];
    
    for j=1:length(instances)
        Ho = cat(2,Ho,arrayfun(@(k) size(instances{j}{k},1),1:length(instances{j})));
        Wo = cat(2,Wo,arrayfun(@(k) size(instances{j}{k},2),1:length(instances{j})));
    end
    
    n_instances = length(Wo);
    
    Wo = median(Wo);
    Ho = median(Ho);
    
    I = zeros(Ho,Wo,3,n_instances);
    l = 1;
    for j=1:length(instances)
        for k=1:length(instances{j})
            I(:,:,:,l) = imresize(instances{j}{k},[Ho,Wo]);
            l = l+1;
        end
    end
    
    X=reshape(I,[],size(I,4));
    X_normalized=X-repmat(mean(X),[size(X,1) 1]);
    X_normalized=X_normalized ./ repmat(sqrt(sum(X_normalized.^2)),[size(X_normalized,1) 1]);
    save([folder 'res/instances/' files(i_file).name(1:end-3) 'mat'],'instances','I','X','X_normalized')
end