%% inspired by xue mei, haibin ling: Robust Visual Tracking using l1 Minimization

folder = '/home/sulcanto/Documents/animal_behavior/data/ants_tracking_scaffolding/80/'
files = dir([folder '*.mov'])
min_area = 200;
max_area = 1000;

i_file = 1;
subsample = 4;
min_area = min_area / subsample;
max_area = max_area / subsample;


t_frames = 300;
lambda_dict = 0.15;
lambda_code = 0.5;
K = 64;
%{
lambda_code = 0.4;
K = 16;
%}
window_type = 'sliding';

for i_file = 1:length(files)

    in = VideoReader([folder files(i_file).name]);
    H = in.Height / subsample;
    W = in.Width / subsample;
   
    mkdir([folder '/res/sparse_coding/' files(i_file).name(1:end-4)])
    % mask
    mask = imread([folder files(i_file).name(1:end-3) 'png']);
    mask = (mask(:,:,1) == 255) & mask(:,:,2) == 0 & mask(:,:,3) == 0;
    mask = imresize(mask,[H,W]);
    
    I = zeros(H,W,3,t_frames,'single');

    % fg-bg detector    
    detector = vision.ForegroundDetector(...
        'NumTrainingFrames', 50, ...
        'InitialVariance', 0.2*0.2);
    % blob analyzer
    blob = vision.BlobAnalysis(...
       'CentroidOutputPort', true, 'AreaOutputPort', true, ...
       'BoundingBoxOutputPort', true, ...
       'MinimumBlobArea', min_area,'MaximumBlobArea', max_area);

    
    
    instances = cell(t_frames,1);
    for f=1:size(I,4)
        img = imresize(im2single(readFrame(in)),[H,W]);
        I(:,:,:,f) = img;
        img_m = step(detector,img);
        img_m = img_m .* mask;
                
        img_m = imopen(img_m, strel('rectangle', [3,3]));
        img_m = imclose(img_m, strel('rectangle', [10, 10]));
        img_m = imfill(img_m, 'holes');
        
        [area,centroid,bbox] = step(blob,img_m > 0);
        %
        imagesc(img); hold on; axis image;
        for i=1:size(area)
            rectangle('Position',bbox(i,:),'EdgeColor','Red')
        end
        pause(0.01);
        %}
        instances{f} = cell(length(bbox),1);
        for i=1:size(bbox,1)
            b = uint16(bbox(i,:));
            patch = (I(b(2):b(2) + b(4),b(1):b(1) + b(3),:,f));
            instances{f}{i} = rgb2gray(patch);
        end
        fprintf('object detection (%i,%i), found %i \n',f,size(I,4),length(instances{f}))
        %}
    end    

    %%
    n_models = arrayfun(@(i) length(instances{i}),1:t_frames);
    Ws = [];
    Hs = [];
    for i=1:length(instances)
        for j=1:length(instances{i})
            Hs(end+1) = size(instances{i}{j},1);
            Ws(end+1) = size(instances{i}{j},2);
        end
    end

    Wo = median(Ws);
    Ho = median(Hs);
    lin = @(v) v(:);
    X = [];

    for i=1:length(instances)
        for j=1:length(instances{i})
            if ~isempty(instances{i}{j})
                X = cat(2,X,lin(imresize(instances{i}{j},[Ho,Wo])));
            end
        end
    end

    X=X-repmat(mean(X),[size(X,1) 1]);
    X=X ./ repmat(sqrt(sum(X.^2)),[size(X,1) 1]);
    %
    param.K=128;  % learns a dictionary with 100 elements
    param.lambda=lambda_dict;
    param.numThreads=-1; % number of threads
    param.batchsize=400;
    param.verbose=false;
    param.pos = true;
    param.iter=1000;  % let us see what happens after 1000 iterations.
    fprintf('dictionary creation %i elems, lambda %f',K,lambda_dict)
    tic
    D = mexTrainDL(X,param);
 
    
    in = VideoReader([folder files(i_file).name]);
    out = VideoWriter([folder '/res/sparse_coding/',files(i_file).name(1:end-3) 'avi'])
    open(out)
    NF = uint16(in.Duration * in.FrameRate);
    frame = 1;
    
    
    while hasFrame(in)
        tic;
        img = im2single(imresize(rgb2gray(readFrame(in)),[H,W]));
        X = im2col(img,[Ho, Wo],window_type);
        X=X-repmat(mean(X),[size(X,1) 1]);
        X=X./ repmat(sqrt(sum(X.^2)),[size(X,1) 1]);
        
        param.lambda = lambda_code;
        param.K = K;
        param.pos = 1;
        alpha=mexLasso(X,D,param);
        alpha_f = full(alpha);
        
        V = zeros((H-Ho+1),(W-Wo+1),param.K);
        for i=1:param.K
            V(:,:,i) = col2im(full(alpha_f(i,:)),[Ho,Wo],[H,W],window_type);
        end
        %{
        img_o = mat2gray(... 
            cat(2,mask .* img,mask.* imresize(mat2gray(sum(V,3)),[H,W])));
        
        imagesc(img_o); pause(0.01); axis image; colormap gray;
        
        writeVideo(out,img_o)
        
        save([folder '/res/sparse_coding/' files(i_file).name(1:end-4) '/' num2str(frame) '.mat'],...
           'alpha','H','W','Ho','Wo','img','D')
       %}
        img_o = mask .* imresize(min(1,max(0,sum(V,3))),[H,W]);
        imagesc(img_o); pause(0.01);
        
        fprintf('\n %s took %f (%i/%i)',files(i_file).name,toc,frame,NF)
        
        frame = frame + 1;
    end


end

b = im;
a = linspace(0,2*pi,16);
for i=1:length(a)
    b = b + nonmax(b,a(i));
end