function [objects] = object_detection_foregound_detection(in,mask,min_area,max_area,max_frames)

hfg = vision.ForegroundDetector(...
        'NumTrainingFrames', 10, ...
        'InitialVariance', 0.01 * 0.1);

objects = [];
width = size(mask,1);
height = size(mask,2);
NF = uint16(in.Duration * in.FrameRate);
max_frames = min(max_frames,NF);

while hasFrame(in)
    tic
    img = readFrame(in);
    img = rgb2gray(img);
    img = im2single(img);
    img = imresize(img,[width,height]);
    
    fg = step(hfg,img);
    
    rprops = regionprops(fg .* mask);
    rprops = rprops([rprops.Area] > min_area & [rprops.Area] < max_area);
    
    a = zeros(length(rprops),1);
    b = zeros(length(rprops),4);
    c = zeros(length(rprops),2);
    for j=1:length(rprops)
        a(j) = rprops(j).Area;
        b(j,:) = rprops(j).BoundingBox;
        c(j,:) = rprops(j).Centroid;
    end
    
    if length(objects) > max_frames
        break
    end
    
    objects(length(objects)+1).area =a;
    objects(end).center = c;
    objects(end).bbox = b;
    fprintf('frame %i of %i, objects %i duration %f\n',length(objects), max_frames,length(rprops),toc)
end
