addpath('../functions/')


in_folder= '/home/sulcanto/animal_behavior/data/ants_tracking_scaffolding/';
out_folder = '/home/sulcanto/tmp/scaffolding/';

folders_angle = dir([in_folder]);
folders_angle = folders_angle([folders_angle.isdir]);
folders_angle = folders_angle(3:end);

for fa = 1:length(folders_angle)
    folders_records = dir([in_folder folders_angle(fa).name '/out/*']);
    folders_records = folders_records([folders_records.isdir]);
    folders_records = folders_records(3:end);
    
    for fr = 1:length(folders_records)
        in_fullpath = [in_folder folders_angle(fa).name '/out/' folders_records(fr).name '/']
        out_fullpath = [out_folder folders_angle(fa).name '/' folders_records(fr).name '/'];
        mkdir([ out_fullpath 'tracks'])
        
        tracks_file = [in_fullpath '/tracks_' folders_records(fr).name '.mat'];
        counts_file = [in_fullpath '/count_' folders_records(fr).name '.mat'];
        if exist( counts_file)
            load(counts_file);
            [~,counts] = binning(frame_occurence_counter);
            csvwrite([out_fullpath '/counts.csv'],[counts])
        end
        if exist ( tracks_file)
            load(tracks_file);
            for t = 1:length(tracks)
                csvwrite([out_fullpath 'tracks/' num2str(t) '.csv'],tracks{t})
            end
        end
        
        
        
        
    end
end