addpath('../libs/SVD/')
addpath('../libs/FPCP/')
%%
folder = '/home/sulcanto/animal_behavior/data/ants_tracking_scaffolding/20/'
files = dir([folder '*.mov'])
%{
% '90_1-23_1.mov', '90_1-31_1.mov','90_1-31_2.mov','90_1-31_3.mov','90_2-1_1.mov,
% '90_2-1_2.mov','90_2-2_1.mov','90_2-2_2.mov','90_2-5_1.mov','90_2-5_2.mov','90_2-5_3.mov'
ys = {  638:937,...
        676:868,...
        652:840,...
        638:752,...
        583:844,...
        599:862,...
        479:784,...
        491:793,...
        542:820,...
        568:853,...
        585:862,...
        }
x = [   1865, ...
        1684,...
        1694,...
        1663,...
        1782,...
        1738,...
        1637,...
        1637,...
        1800,...
        178,...
        135]
 %}   

%{
% 80
'80_1-23_1.mov'    '80_1-31_1.mov'    '80_1-31_2a.mov'    '80_1-31_2b.mov'    '80_1-31_3.mov'
'80_2-1_1.mov'    '80_2-1_2.mov'    '80_2-2_1.mov'    '80_2-2_2.mov'    '80_2-5_1.mov'
'80_2-5_2.mov'    '80_2-6_1.mov'

ys = {  607:912,...
        637:865,...
        676:871,...
        670:864,...
        581:748,...
        585:830,...
        534:802,...
        453:755,...
        481:780,...
        561:849,...
        550:824,...
        612:909}
x = [1768,...
     1679,...
     1688,...
     1609,...
     1653,...
     1821,...
     1794,...
     1794,...
     1763,...
     1768,...
     1724,...
     1772, ]
%}

%{
'70_1-23_1.mov'    '70_1-23_2.mov'    '70_1-31_1.mov'    '70_1-31_2.mov'    '70_2-1_1.mov'
'70_2-1_2.mov'    '70_2-2_1.mov'    '70_2-2_2.mov'    '70_2-2_3_notraffi…'    '70_2-5_1.mov'
'70_2-5_2.mov'    '70_2-5_3.mov'
%
ys = {  596:846,...
        652:953,...
        680:869,...
        609:769,...
        663:877,...
        583:842,...
        491:761,...
        487:780,...
        518:814,...
        569:853,...
        611:893,...
        581:879
        }
x = [   1693,...
        1887,...
        1763,...
        1817,...
        228,...
        1790,...
        1693,...
        1728,...
        1732,...
        1830,...
        189,...
        82]
%}

%{   
'60_1-23_1.mov'    '60_1-23_2.mov'    '60_1-31_1.mov'    '60_1-31_2.mov'
'60_2-1_1.mov'    '60_2-1_2.mov'    '60_2-2_1.mov'    '60_2-2_2.mov'
'60_2-5_1.mov'    '60_2-5_2.mov'    '60_2-5_3.mov'    '60_2-6_1.mov'


ys = {  589:887,...
        651:947,...
        624:853,...
        595:762,...
        579:835,...
        531:793,...
        483:759,...
        487:772,...
        558:844,...
        537:823,...
        529:812,...
        589:906}
x = [   1725,...
        1901,...
        1729,...
        1769,...
        1778,...
        1852,...
        1624,...
        1826,...
        1813,...
        1795,...
        1786,...
        1729]
%}

%{
'50_1-23_1.mov'    '50_1-31_1.mov'    '50_1-31_2.mov'    '50_1-31_3.mov'    '50_2-1_1.mov'    '50_2-1_2.mov'    '50_2-2_1.mov'    '50_2-2_2.mov'    '50_2-5_1.mov'
'50_2-5_2.mov'    '50_2-6_1.mov'


ys = {  607:911,...
        629:850,...
        680:866,...
        585:745,...
        581:836,...
        529:793,...
        461:760,...
        492:791,...
        559:841,...
        538:821,...
        647:1006}

x = [1659,...
     1605,...
     1848,...
     1630,...
     1737,...
     1750,...
     1707,...
     1765,...
     1795,...
     1697,...
     1582]
%}

%{
'40_2-5_1.mov','40_2-5_2.mov','40_2-5_3.mov','40_2-5_4.mov','40_2-5_5.mov','40_2-6_1.mov','40_2-6_2.mov','40_2-6_3.mov','40_2-6_4.mov'
'40_2-6_5.mov'

ys = {  578:863,...
        573:841,...
        576:849,...
        545:819,...
        538:802,...
        638:978,...
        651:947,...
        632:931,...
        636:938,...
        625:903}
        
x = [  1773,...
        1778,...
        1778,...
        1778,...
        1762,...
        1659,...
        1637,...
        1690,...
        1744,...
        1770]
%}    
        
%{
    '30_2-5_1.mov'    '30_2-5_2.mov'    '30_2-5_3.mov'    '30_2-5_4.mov'    '30_2-5_5.mov'    '30_2-5_short.mov'    '30_2-6_1.mov'    '30_2-6_2.mov'
    '30_2-6_3.mov'    '30_2-6_4.mov'    '30_2-6_5.mov'    '30_2-6_6.mov'


ys = {  571:837,...
        576:846,...
        549:824,...
        540:815,...
        532:810,...
        576:846,...
        642:921,...
        656:881,...
        647:894,...
        630:881,...
        629:859,...
        598:881};
        
x = [  1741,...
        1759,...
        1759,...
        1803,...
        1777,...
        1830,...
        1722,...
        1626,...
        1768,...
        1684,...
        1657,...
        1684]
%}

%{
    '20_2-5_1.mov'    '20_2-5_2.mov'    '20_2-5_3.mov'    '20_2-5_4.mov'    '20_2-5_5.mov'    '20_2-6_1.mov'
    '20_2-6_2.mov'    '20_2-6_3.mov'    '20_2-6_4.mov'    '20_2-6_5.mov'


ys = {  560:845,...
        563:837,...
        571:846,...
        544:810,...
        532:790,...
        651:983,...
        628:992,...
        660:952,...
        633:863,...
        625:872}
x = [   1706,...
        1724,...
        1759,...
        1719,...
        1768,...
        1569,...
        1768,...
        1648,...
        1662,...
        1648]
%}
for i=1:length(files)
    in = VideoReader([folder files(i).name])
    NF = uint16(in.Duration * in.FrameRate);
    I = zeros(NF,numel(ys{i}));
    
    for f=1:NF
        img = im2double(readFrame(in));
        img_bw = rgb2gray(img);
        I(f,:) = img_bw(ys{i},x(i));
        fprintf('%s (%i of %i files) (%i of %i frames)\n',files(i).name,i,length(files),f,NF)
    end
    
    [~,S] = fastpcp(I,0.3);
    S = S~=0;
    
    props = regionprops(S,'PixelList','Area');
    ok = ([props.Area] > 5) & ([props.Area]<25);
    props = props(ok);
    frame_occurence_counter = zeros(NF,1,'uint16');
    for j=1:length(props)
        start = min(props(j).PixelList(:,2));
        stop = max(props(j).PixelList(:,2));
        frame_occurence_counter(start:stop) = frame_occurence_counter(start:stop) + 1;
    end
    
    img(ys{i},x(i),1) = 1;
    img(ys{i},x(i),2) = 0;
    img(ys{i},x(i),3) = 0;
    
    save([folder '/out/' files(i).name(1:end-4) '/count_' files(i).name(1:end-4) '.mat'],...
        'I','S','frame_occurence_counter','img')
    imwrite(img, [folder '/out/' files(i).name(1:end-4) '/count_' files(i).name(1:end-4) '.png'])
    % pause
end

%% binning

[counts]  = binning(f.frame_occurence_counter)


%%
clear all
folder = '/home/sulcanto/animal_behavior/data/ants_tracking_scaffolding/20/'
files = dir([folder '*.mov'])

for i=1:length(files)
    name = files(i).name
    in = VideoReader([folder name])
    img = readFrame(in);
    imagesc(img); axis off; axis image;
    title(name)
    pause
end